%%
%% This is file `guletter.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% guletter.dtx  (with options: `letter')
%% Glasgow University headed paper style
%% GUletter package -- produce GU `letterhead' letters.
%% Revision: Mercurial a0864aa092f8, 2025-11-18 22:35 +0000, tag 2.4.1+0
%%
%% This is a modification of the LaTeX2e standard letter style, to include
%% the GU logo, and to conform to the `visual identity'....
%%
%% This file is based on v1.2j of letter.dtx, which was included in the
%% first complete LaTeX2e release, of June 1994.  That file is Copyright
%% (C) 1994 LaTeX3 project, Frank Mittelbach and Rainer Sch\"opf.
%%
%% This software is copyright, 1995--2004, 2007--17, Norman Gray.
%%
%% ***** BEGIN LICENSE BLOCK *****
%% Version: MPL 1.1
%%
%% The contents of this file are subject to the Mozilla Public License Version
%% 1.1 (the "License"); you may not use this file except in compliance with
%% the License. You may obtain a copy of the License at
%% http://www.mozilla.org/MPL/
%%
%% Software distributed under the License is distributed on an "AS IS" basis,
%% WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
%% for the specific language governing rights and limitations under the
%% License.
%%
%% The Original Code is The GUletter class.
%%
%% The Initial Developer of the Original Code is
%% Norman Gray, <http://nxg.me.uk>.
%% Portions created by the Initial Developer are Copyright (C) 1995--2004, 2007--13, Norman Gray.
%% All Rights Reserved.
%%
%% Contributor(s):
%%
%% ***** END LICENSE BLOCK *****
%%
%% Author: Norman Gray, norman@astro.gla.ac.uk.
%% School of Physics and Astronomy, University of Glasgow, UK
\def\filename{guletter}
\def\fileversion{2.4.1}
\def\filedate{2025/11/18}
\def\docdate{2025 November 18}
\def\MercurialIdentifier{Mercurial a0864aa092f8, 2025-11-18 22:35 +0000, tag 2.4.1+0}
\ProvidesClass{guletter}
 [\filedate\space v\fileversion
\space University of Glasgow letterhead class
 ]
\NeedsTeXFormat{LaTeX2e}
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\newcommand\@ptsize{0}
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\if@compatibility
  \DeclareOption{twoside}{\@latexerr{No 'twoside' layout for letters}%
                                   \@eha}
\else
  \DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\fi
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\newif\if@guletter@raggedright
  \@guletter@raggedrightfalse
\DeclareOption{raggedright}{\@guletter@raggedrighttrue}
\newif\ifunilogo \unilogotrue
\newif\ifaddressblock \addressblocktrue
\newif\ifuniletter      \unilettertrue
\newif\if@guletter@openclose \@guletter@openclosetrue

\DeclareOption{useheadedpaper}{\unilogofalse \addressblockfalse}
\DeclareOption{makeheadedpaper}{\unilogotrue \addressblocktrue \@guletter@openclosefalse}
\newif\ifpsfonts \psfontstrue
\DeclareOption{cmfonts}{\psfontsfalse}
\newif\if@guletter@colour
\@guletter@colourtrue
\DeclareOption{colour}
  {\@guletter@colourtrue\PassOptionsToPackage{colour}{gulogo}}
\DeclareOption{color}
  {\@guletter@colourtrue\PassOptionsToPackage{colour}{gulogo}}
\DeclareOption{kulur}
  {\@guletter@colourtrue\PassOptionsToPackage{colour}{gulogo}}
\DeclareOption{black}
  {\@guletter@colourfalse\PassOptionsToPackage{black}{gulogo}}
\newif\ifdraft\draftfalse
\DeclareOption{draft}{\drafttrue\typeout
{*** DRAFT ***}\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\newif\if@yourref\@yourreffalse
\DeclareOption{personal}{\unilogofalse
\typeout{(Personal letter variant)}
        \uniletterfalse}
\DeclareOption{personalletter}{\unilogofalse
\typeout{(Personal letter variant)}
\ClassWarning{guletter}{Please use option [personal], rather
than [personalletter]}
        \uniletterfalse}
\DeclareOption{fax}{\ClassWarning{guletter}{Fax letter variant not implemented}}
\newtoks\@addressset
\@addressset={\relax}
\DeclareOption{Arts}{\PassOptionsToPackage{Arts}{gulogo}}
\DeclareOption{MVLS}{\PASSOPTIONSTOPACKAGE{MVLS}{gulogo}}
\DeclareOption{SciEng}{\PassOptionsToPackage{SciEng}{gulogo}}
\DeclareOption{SocSci}{\PassOptionsToPackage{SocSci}{gulogo}}

\DeclareOption{CompSci}{\ExecuteOptions{SciEng}
      \@addressset={%
        \school{School of Computing Science}%
\schoollogotext{School of}{Computing Science}%
\schooladdress{8--17 Lilybank Gardens, Glasgow, G12 8RZ}%
\telephone{+44 141 330 4256}}}
\DeclareOption{Engineering}{\ExecuteOptions{SciEng}
      \@addressset={%
        \school{School of Engineering}
        \schoollogotext{School of}{Engineering}%
        \homepage{https://www.gla.ac.uk/schools/engineering/}
        \telephone{0141 330 5858}
        \schooladdress{James Watt South Building\\University of Glasgow\\Glasgow G12~8QQ\\U.K.}}}
\DeclareOption{Maths}{\ExecuteOptions{SciEng}
      \@addressset={%
        \school{School of Mathematics and Statistics}
        \schoollogotext{School of Mathematics}{\& Statistics}
        \telephone{0141 330 5176}
        \homepage{https://www.gla.ac.uk/schools/mathematicsstatistics/}}}
\DeclareOption{PandA}{\ExecuteOptions{SciEng}
      \@addressset={%
\school{School of Physics and Astronomy}%
        \schoollogotext{School of Physics}{\& Astronomy}
        \schooladdress{School of Physics \& Astronomy\\University of Glasgow\\Glasgow, G12~8QQ\\UK}
        %\schooladdress{Kelvin Building, University Avenue, Glasgow, G12 8QQ, UK}
        \homepage{https://www.gla.ac.uk/schools/physics/}
        }}
\def\GUL@extradefs{}
\def\GUL@readclo#1{\input{#1.clo}}
\AtBeginDocument{\GUL@extradefs}
\DeclareOption*{
  \IfFileExists{\CurrentOption.clo}
    {% Use a trick from the TeXBook exercise 20.15
      \@temptokena=\expandafter{\GUL@extradefs}
      \edef\GUL@extradefs{\the\@temptokena\noexpand\GUL@readclo{\CurrentOption}}}
    {\ClassError{guletter}
      {Bad option \CurrentOption}
      {I don't understand the option \CurrentOption\MessageBreak
        (I didn't find file \CurrentOption.clo, if that's what you meant)}}}
\ExecuteOptions{a4paper,10pt,oneside,onecolumn,final,colour}
\ProcessOptions
%% This is file `size10.clo',
%% ...with \if@compatibility branches stripped, and baselineskip increased
\renewcommand\normalsize{%
   \@setfontsize\normalsize{10}{14}%% CHANGE
   \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\normalsize
\newcommand\small{%
   \@setfontsize\small\@ixpt{11}%
   \abovedisplayskip 8.5\p@ \@plus3\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus2\p@
   \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 4\p@ \@plus2\p@ \@minus2\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\newcommand\footnotesize{%
   \@setfontsize\footnotesize\@viiipt{9.5}%
   \abovedisplayskip 6\p@ \@plus2\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus\p@
   \belowdisplayshortskip 3\p@ \@plus\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 3\p@ \@plus\p@ \@minus\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\newcommand\scriptsize{\@setfontsize\scriptsize\@viipt\@viiipt}
\newcommand\tiny{\@setfontsize\tiny\@vpt\@vipt}
\newcommand\large{\@setfontsize\large\@xiipt{14}}
\newcommand\Large{\@setfontsize\Large\@xivpt{18}}
\newcommand\LARGE{\@setfontsize\LARGE\@xviipt{22}}
\newcommand\huge{\@setfontsize\huge\@xxpt{25}}
\newcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
\if@twocolumn
  \setlength\parindent{1em}
\else
  \setlength\parindent{15\p@}
\fi
\setlength\smallskipamount{3\p@ \@plus 1\p@ \@minus 1\p@}
\setlength\medskipamount{6\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\bigskipamount{12\p@ \@plus 4\p@ \@minus 4\p@}
\setlength\headheight{12\p@}
\setlength\headsep   {25\p@}
\setlength\topskip   {10\p@}
\setlength\footskip{30\p@}
\setlength\maxdepth{.5\topskip}
  \setlength\@tempdima{\paperwidth}
  \addtolength\@tempdima{-2in}
  \setlength\@tempdimb{345\p@}
  \if@twocolumn
    \ifdim\@tempdima>2\@tempdimb\relax
      \setlength\textwidth{2\@tempdimb}
    \else
      \setlength\textwidth{\@tempdima}
    \fi
  \else
    \ifdim\@tempdima>\@tempdimb\relax
      \setlength\textwidth{\@tempdimb}
    \else
      \setlength\textwidth{\@tempdima}
    \fi
  \fi
  \@settopoint\textwidth
  \setlength\@tempdima{\paperheight}
  \addtolength\@tempdima{-2in}
  \addtolength\@tempdima{-1.5in}
  \divide\@tempdima\baselineskip
  \@tempcnta=\@tempdima
  \setlength\textheight{\@tempcnta\baselineskip}
\addtolength\textheight{\topskip}
\if@twocolumn
 \setlength\marginparsep {10\p@}
\else
  \setlength\marginparsep{11\p@}
\fi
\setlength\marginparpush{5\p@}
  \if@twoside
    \setlength\@tempdima        {\paperwidth}
    \addtolength\@tempdima      {-\textwidth}
    \setlength\oddsidemargin    {.4\@tempdima}
    \addtolength\oddsidemargin  {-1in}
    \setlength\marginparwidth   {.6\@tempdima}
    \addtolength\marginparwidth {-\marginparsep}
    \addtolength\marginparwidth {-0.4in}
  \else
    \setlength\@tempdima        {\paperwidth}
    \addtolength\@tempdima      {-\textwidth}
    \setlength\oddsidemargin    {.5\@tempdima}
    \addtolength\oddsidemargin  {-1in}
    \setlength\marginparwidth   {.5\@tempdima}
    \addtolength\marginparwidth {-\marginparsep}
    \addtolength\marginparwidth {-0.4in}
    \addtolength\marginparwidth {-.4in}
  \fi
  \ifdim \marginparwidth >2in
     \setlength\marginparwidth{2in}
  \fi
  \@settopoint\oddsidemargin
  \@settopoint\marginparwidth
  \setlength\evensidemargin  {\paperwidth}
  \addtolength\evensidemargin{-2in}
  \addtolength\evensidemargin{-\textwidth}
  \addtolength\evensidemargin{-\oddsidemargin}
  \@settopoint\evensidemargin
  \setlength\topmargin{\paperheight}
  \addtolength\topmargin{-2in}
  \addtolength\topmargin{-\headheight}
  \addtolength\topmargin{-\headsep}
  \addtolength\topmargin{-\textheight}
  \addtolength\topmargin{-\footskip}     % this might be wrong!
  \addtolength\topmargin{-.5\topmargin}
  \@settopoint\topmargin
\setlength\footnotesep{6.65\p@}
\setlength{\skip\footins}{9\p@ \@plus 4\p@ \@minus 2\p@}
\setlength\floatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\textfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\intextsep   {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dblfloatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\@fptop{0\p@ \@plus 1fil}
\setlength\@fpsep{8\p@ \@plus 2fil}
\setlength\@fpbot{0\p@ \@plus 1fil}
\setlength\@dblfptop{0\p@ \@plus 1fil}
\setlength\@dblfpsep{8\p@ \@plus 2fil}
\setlength\@dblfpbot{0\p@ \@plus 1fil}
\setlength\partopsep{2\p@ \@plus 1\p@ \@minus 1\p@}
\def\@listi{\leftmargin\leftmargini
            \parsep 4\p@ \@plus2\p@ \@minus\p@
            \topsep 8\p@ \@plus2\p@ \@minus4\p@
            \itemsep4\p@ \@plus2\p@ \@minus\p@}
\let\@listI\@listi
\@listi
\def\@listii {\leftmargin\leftmarginii
              \labelwidth\leftmarginii
              \advance\labelwidth-\labelsep
              \topsep    4\p@ \@plus2\p@ \@minus\p@
              \parsep    2\p@ \@plus\p@  \@minus\p@
              \itemsep   \parsep}
\def\@listiii{\leftmargin\leftmarginiii
              \labelwidth\leftmarginiii
              \advance\labelwidth-\labelsep
              \topsep    2\p@ \@plus\p@\@minus\p@
              \parsep    \z@
              \partopsep \p@ \@plus\z@ \@minus\p@
              \itemsep   \topsep}
\def\@listiv {\leftmargin\leftmarginiv
              \labelwidth\leftmarginiv
              \advance\labelwidth-\labelsep}
\def\@listv  {\leftmargin\leftmarginv
              \labelwidth\leftmarginv
              \advance\labelwidth-\labelsep}
\def\@listvi {\leftmargin\leftmarginvi
              \labelwidth\leftmarginvi
              \advance\labelwidth-\labelsep}
%% End of file `size10.clo'.
%% \newif\ifXeTeX
%% \XeTeXfalse
%% \expandafter\ifx\csname XeTeXversion\endcsname\relax \else
%%   \XeTeXtrue
%% \fi
\RequirePackage{ifxetex}
\ifxetex
    \pdfpagewidth=\paperwidth
    \pdfpageheight=\paperheight
\fi
\ifpsfonts
  \ifxetex
    % We're using XeTeX
    \RequirePackage{fontspec}
    \setmainfont{Helvetica Neue Light}
    \setmonofont[Scale=0.85]{Monaco}
    % This seems the most reliable way of supporting \pounds within XeTeX
    \def\textsterling{£}
    \def\mathsterling{£}
  \else
    % the NFSS packages are happier with T1 encoding
    \RequirePackage[T1]{fontenc}
    \RequirePackage{helvet}
    \renewcommand{\rmdefault}{phv}
  \fi
\fi
\ifunilogo
  \RequirePackage{gulogo}
\fi
\if@guletter@colour
  \RequirePackage{color}
  \definecolor{personalcolour}{rgb}{0.4,0.2,0.2}
  \definecolor{draftcolour}{rgb}{0.8,0.5,0.5}
\fi
\@ifundefined{gulogo@textcolourbegin}
  { \ifuniletter
      \let\gu@addressblockcolourbegin\relax % leave it black
    \else
      \def\gu@addressblockcolourbegin{\color{personalcolour}}
    \fi
    \let\gu@addressblockcolourend\relax
  }
  { \let\gu@addressblockcolourbegin\gulogo@textcolourbegin
    \let\gu@addressblockcolourend  \gulogo@textcolourend }
\setlength\lineskip{1pt}
\setlength\normallineskip{1pt}
\renewcommand\baselinestretch{}
\parskip\baselineskip
\setlength\parindent{0\p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setlength\headheight{12\p@}
\setlength\headsep   {45\p@}
\setlength\footskip{25\p@}
\if@compatibility
  \setlength\maxdepth{4\p@}
\else
  \setlength\maxdepth{.5\topskip}
\fi
\setlength\@maxdepth\maxdepth
\setlength\textwidth{468\p@}
\setlength\textheight{567\p@}
\setlength\oddsidemargin{25mm}
  \advance\oddsidemargin -1in
\setlength\evensidemargin  {\oddsidemargin}
\setlength\marginparwidth  {90\p@}
\setlength\marginparsep {11\p@}
\setlength\marginparpush{5\p@}
\setlength\topmargin{27pt}
\setlength\footnotesep{12\p@}
\setlength{\skip\footins}{10\p@ \@plus 2\p@ \@minus 4\p@}
\if@twoside
  \def\ps@headings{%
      \let\@oddfoot\@empty\let\@evenfoot\@empty
      \def\@oddhead{\slshape\headtoname{} \ignorespaces\toname
                    \hfil \@date
                    \hfil \pagename{} \thepage}%
      \let\@evenhead\@oddhead
\else
  \def\ps@headings{%
      \let\@oddfoot\@empty
      \def\@oddhead{\slshape\headtoname{} \ignorespaces\toname
                    \hfil \@date
                    \hfil \pagename{} \thepage}}
\fi
\def\ps@empty{%
      \let\@oddfoot\@empty\let\@oddhead\@empty
      \let\@evenfoot\@empty\let\@evenhead\@empty}
\newdimen\logotopmargin
\newdimen\logoleftmargin
\logotopmargin=14mm
\logoleftmargin=25mm
\def\guletter@draftbox{\setbox0=\hbox to 0pt{\hss
    \fontsize{72}{72}\selectfont
    \if@guletter@colour
      \textcolor{draftcolour}{DRAFT}%
    \else
      DRAFT%
    \fi
  \hss}
  \ht0=0pt
  \box0}
\def\ps@firstpage{%
  \def\@oddhead{}%
  \def\@oddfoot{%
    \newdimen\gu@addressboxshift
    \gu@addressboxshift=\paperheight
    \advance \gu@addressboxshift -1in
    \advance \gu@addressboxshift -\voffset
    \advance \gu@addressboxshift -\topmargin
    \advance \gu@addressboxshift -\headheight
    \advance \gu@addressboxshift -\headsep
    \advance \gu@addressboxshift -\textheight
    \advance \gu@addressboxshift -\footskip
    \advance \gu@addressboxshift -10mm
    \iftrue
      \typeout{base of text is \the\gu@addressboxshift\ from bottom of footer}%
    \fi
    \ifaddressblock
      \setbox\@tempboxa\vbox{
        \hsize 150mm
        \parindent=0pt \parskip=0pt
        \fontsize{9}{10}\selectfont
        \raggedright
        \gu@addressblockcolourbegin
        \addressblockhook
        %
        \ifx\gu@groupname\@empty\else {\fontsize{18}{18}\selectfont \gu@groupname\vskip 10pt}\fi %XXX

        % The From name and qualifications don't currently appear in
        % the design.
        %\ifx\gu@name\@empty
        %  \ClassError{guletter}{The From name must be present}%
        %    {Use the \string\name\ command to define it}
        %\else
        %  {\bfseries \gu@name}
        %\fi
        %
        %\ifx\gu@qualifications\@empty
        %\else
        %  \gu@qualifications %\hbox{\strut \gu@qualifications}
        %\fi

        % The 'position' no longer appears at the bottom.
        % But leave it here, in case they decide to change their formatting minds yet again.
        %\ifx\gu@position\@empty
        %\else
        %  \gu@position %\hbox{\strut \gu@position}
        %\fi

        \vskip 3pt
        \ifuniletter                % object to this
     \ifx\gu@school\@empty
            \ClassError{guletter}{You haven't specified a school name}%
              {You must give a school (or other organisational unit) name.\MessageBreak
              If one is not predefined for you, use the\MessageBreak
              \string\school\ command to define it.  Note that the\MessageBreak
              'school' can be any organisation unit.}%
          \else
            \def\\{, }
            %\gu@school,
            \gu@schooladdress
          \fi
        \else
          \ifx\gu@name\@empty
            \ifx\gu@sig\@empty
              \ClassError{guletter}{Must provide name or signature}{like it says...}
            \else
              \gu@sig,
            \fi
          \else
            \gu@name,
          \fi
          \def\\{, }\gu@myaddress
        \fi
        \ifx\telephonenum\@empty
          \ClassError{guletter}{The telephone number must be present}%
            {You must give a telephone number.\MessageBreak
              If one is not predefined for you, use the\MessageBreak
              \string\telephone\ command to define it.}%
        \else
          \def\@tempa{X}%
          \ifx\telephonenum\@tempa
            % do nothing -- number positively suppressed
          \else
            % normal case
            \hskip0.5em plus 2em \hbox{\textit{Tel:}\ \telephonenum}%
          \fi
        \fi
        \ifx\faxnum\@empty\else \hskip0.5em plus 2em \hbox{\textit{Fax:}\ \faxnum}\fi
        \ifx\telexnum\@empty\else \hskip0.5em plus 2em \hbox{\textit{Telex:}\ \telexnum}\fi

        \ifx\emailaddress\@empty
          \ifuniletter
            \ClassError{guletter}{No email address present}%
              {You must give an email address.\MessageBreak
                If one is not predefined for you, use the\MessageBreak
                \string\email\ command to define it.}
          \fi
        \else
          %{\it Email: }
          %\@ifUC{\emailaddress}{\fontsize{8}{12pt}}
          \emailaddress
        \fi
        \ifx\homepageURL\@empty\else , \GU@writeURL\fi
        \ifuniletter
          \vskip\baselineskip
          \fontsize{8}{9}\selectfont
          The University of Glasgow, charity number SC004401%
        \fi
     \gu@addressblockcolourend
    }                           % end of \vbox
    \vbox to 0pt{\vss
      \ifdraft
        \vbox to 0pt{\vss
          \hbox to \textwidth{\hfil\guletter@draftbox\hfil}}%
      \fi
      \hskip0pt \box\@tempboxa
      \vskip-\gu@addressboxshift}
  \fi                           % end if \ifaddressblock
}}                              % end of \@oddfoot and \ps@firstpage
\let\addressblockhook\relax
\def\@testUC#1#2\@null{\ifnum `#1=\the\uccode`#1 }
\def\@ifUC#1#2{\expandafter \@testUC #1\@null #2\fi}
{\catcode`\/=\active
\gdef\GU@writeURL{\begingroup
  \catcode`\/=\active \def/{\kern-0.5pt \char`\/\kern-0.5pt }
  %\quad {\it WWW: }
  \homepageURL\endgroup}}
\def\ps@plain{%
      \let\@oddhead\@empty
      \ifdraft
        \def\@oddfoot{\rmfamily\hfil\guletter@draftbox\hfil}%
      \else
        \def\@oddfoot{\rmfamily\hfil\thepage\hfil}%
      \fi
      \def\@evenfoot{\rmfamily\hfil\thepage\hfil}}
\def\gu@raggedright{%
  \let\\\@centercr
  \@rightskip=0pt plus 3em
  \spaceskip=.3333em \xspaceskip=.5em
  \rightskip\@rightskip
  \leftskip\z@skip
  \parindent\z@}
\def\p@thdots{\discretionary{.}{}{.}}
\def\p@thslash{\discretionary{/}{}{/}}
{\catcode`\.=\active \catcode`\/=\active
  \gdef\p@thcats{\begingroup
    \catcode`\%=12 \catcode`\~=12
    \catcode`\.=\active \let.\p@thdots
    \catcode`\/=\active \let/\p@thslash
    \tt \p@th}}
\def\p@th#1{\if@tempswa <#1>\else #1\fi \endgroup}
\def\path{\@tempswafalse\p@thcats}
\def\url {\@tempswatrue \p@thcats}
\def\name#1{\def\gu@name{#1}} \def\gu@name{}
\def\position#1{\def\gu@position{#1}}           \def\gu@position{}
\def\qualifications#1{\def\gu@qualifications{#1}}
                                                \def\gu@qualifications{}
\def\signature#1{\def\gu@sig{#1}} \def\gu@sig{}
\def\signaturegraphic#1{\def\gu@siggraphic{#1}} \def\gu@siggraphic{}
\long\def\address#1{\def\gu@address{#1}} \def\gu@address{}
\def\location#1{\def\gu@location{#1}}           \def\gu@location{}
\def\school#1{\def\gu@school{#1}}               \def\gu@school{}
\def\schooladdress#1{\def\gu@schooladdress{#1}}
  \def\gu@schooladdress{The University of Glasgow,
    Glasgow G12 8QQ, U.K.}
\def\schoollogotext#1#2{\def\gu@schoollogotext{{#1}{#2}}}
  \def\gu@schoollogotext{}
\def\groupname#1{\def\gu@groupname{#1}}         \def\gu@groupname{}
\def\myaddress#1{\def\gu@myaddress{#1}}
\def\telephone#1{\def\telephonenum{#1}} \def\telephonenum{0141-339 8855}
\def\notelephone{\def\telephonenum{X}}
\def\fax#1{\def\faxnum{#1}} \def\faxnum{}
\def\telex#1{\def\telexnum{#1}} \def\telexnum{}
\def\yourref#1{\@yourreftrue\def\@yourref{#1}} \def\@yourref{}
\def\ourref#1{\@yourreftrue\def\@ourref{#1}} \def\@ourref{}
\def\email{\begingroup \catcode`\@=12 \catcode`\_=12\read@email}
\def\read@email#1{\gdef\emailaddress{#1}\endgroup}
\def\emailaddress{}
\def\homepage{\begingroup \catcode`\/=\active
  \catcode`\%=12 \catcode`\~=12 \read@homepage}
\def\read@homepage#1{\gdef\homepageURL{#1}\endgroup}
\def\homepageURL{}
\the\@addressset
\newenvironment{letter}[1]
  {\newpage
    \if@twoside \ifodd\c@page
                \else\thispagestyle{empty} \hbox{}\newpage\fi
    \fi
    \c@page\@ne
    \interlinepenalty=200 % smaller than the TeXbook value
    \if@guletter@raggedright
      \gu@raggedright
    \fi
    \@processto{\leavevmode\ignorespaces #1}}
  {\stopletter\@@par\pagebreak\@@par}
\long\def\@processto#1{\@xproc #1\\@@@\ifx\toaddress\@empty
    \else \@yproc #1@@@\fi}
\long\def\@xproc #1\\#2@@@{\def\toname{#1}\def\toaddress{#2}}
\long\def\@yproc #1\\#2@@@{\def\toaddress{#2}}
\def\stopbreaks{\interlinepenalty \@M
   \def\par{\@@par\nobreak}\let\\=\@nobreakcr
   \let\vspace\@nobreakvspace}
\def\@nobreakvspace{\@ifstar{\@nobreakvspacex}{\@nobreakvspacex}}

\def\@nobreakvspacex#1{\ifvmode\nobreak\vskip #1\relax\else
               \@bsphack\vadjust{\nobreak\vskip #1}\@esphack\fi}

\def\@nobreakcr{\vadjust{\penalty\@M}\@ifstar{\@xnewline}{\@xnewline}}
\def\startbreaks{\let\\=\@normalcr
   \interlinepenalty 200\def\par{\@@par\penalty 200\relax}}

\newdimen\longindentation
\longindentation=.5\textwidth
\newdimen\indentedwidth
\indentedwidth=\textwidth
\advance\indentedwidth -\longindentation
\def\opening#1{\thispagestyle{firstpage}% footer
  \ifunilogo
    \ifx\gu@schoollogotext\@empty
      \GUlogoabspos[pos=ul,width=60mm]\logoleftmargin\logotopmargin
    \else
      \edef\@tempa{[pos=ul,width=60mm,text=\gu@schoollogotext]}
      \expandafter\GUlogoabspos\@tempa\logoleftmargin\logotopmargin
    \fi
  \else
    \vbox to 0pt{}%
  \fi
  \nointerlineskip
    \@tempdima=32mm
    \advance\@tempdima -1in
    \advance\@tempdima -\voffset
    \advance\@tempdima -\topskip
    \advance\@tempdima -\topmargin
    \advance\@tempdima -\headheight
    \advance\@tempdima -\headsep
    \vskip \@tempdima
    \vbox to 0pt{
      \vskip 67mm
      \hbox to 0pt{%
        \hss
        \vrule height 0.15pt width 10mm
        \hskip 20mm}
      \vss}
    \if@guletter@openclose
      \nointerlineskip
       \vskip10mm
       \nointerlineskip
    %\vtop to 4mm{\vskip 1cm \hbox to \textwidth{\hfil\@date}\vss}%
    %\vtop to 4mm{\vskip 2cm \hbox to \textwidth{\hfil\@date}\vss}%
    %\nointerlineskip
      \vbox to 35mm{\textwidth 76mm\raggedright\LetterBodyFont
        \let\bs\\\def\\{\bs\advance\@tempcnta by 1
          \ifnum\@tempcnta>7 \ClassError{guletter}%
            {Too many lines in address}%
            {There is a maximum of eight lines in the To: address\MessageBreak
              You might want to shorten the address somewhat}\fi}%
        \@tempcnta=0
        \vfil
        \toname \\ \toaddress
        %\par
        \vfil
      }%
      \nointerlineskip
      \vbox to 10mm{\vss\@date}
      \nointerlineskip
      \vbox to 16mm{\vss
\if@yourref
            \raggedright
    Your Ref:\ifx\@empty\@yourref\else\ \@yourref\fi\\%
    Our Ref:\ifx\@empty\@ourref\else\ \@ourref\fi\par
\fi}%
      \nointerlineskip
      \raggedright
      \LetterBodyFont
      #1\par\nobreak
    \fi
}
\long\def\@guletter@closing@actual#1{%
  \par\nobreak
  \vspace{\parskip}\stopbreaks
  \noindent
  \ifx\@empty\gu@address\else
    \hspace*{\longindentation}%
  \fi
  \parbox{\indentedwidth}{%
      \raggedright
      \ignorespaces #1
      \ifx\gu@siggraphic\@empty
        % This seems to have been 6\medskipamount at one point, but
        % that's daftly large.  4\baselineskip is fine.
        \vskip4\baselineskip
      \else
        % Vertically-centred box -- not ideal, but the best place to
        % tweak this is probably within the graphic itself
        \vbox to 6\medskipamount{\vss\includegraphics{\gu@siggraphic}\vss}
      \fi
      \ifx\@empty\gu@sig                 % name of author, preferring 'signature' over 'name'
        \gu@name
      \else
        \gu@sig
      \fi
      \ifx\gu@position\@empty\strut\else\par\gu@position\fi % insert position, if there is one
   }%
   \let\cc\gu@cc
   \let\encl\gu@encl
   \let\ps\gu@ps
   \par}
\def\closing{%
  \if@guletter@openclose
    \let\@tempa\@guletter@closing@actual
  \else
    \let\@tempa\@gobble
  \fi
  \@tempa
}
\medskipamount=\parskip
\def\gu@cc#1{\par\noindent
\parbox[t]{\textwidth}{\@hangfrom{\reset@font\rm \ccname: }%
                       \ignorespaces #1\strut}\par}
\def\gu@encl#1{\par\noindent
\parbox[t]{\textwidth}{\@hangfrom{\reset@font\rm \enclname: }%
                       \ignorespaces #1\strut}\par}
\def\gu@ps{\par\startbreaks}
\def\gu@badcc#1{\ClassError{guletter}
  {Misplaced command, #1}
  {The commands \string\cc, \string\encl, and \string\ps\ can only be
    given after \string\closing}}
\def\cc{\gu@badcc{cc}}
\def\encl{\gu@badcc{encl}}
\def\ps{\gu@badcc{ps}}
\def\stopletter{}
\newcommand\section{\@startsection {section}{1}{\z@}%
                                   {-1.5ex \@plus -0.5ex \@minus -.2ex}%
                                   {1.25ex \@plus.2ex}%
                                   {\normalfont\Large\bfseries\sffamily}}
\newcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-1ex\@plus -0.5ex \@minus -.2ex}%
                                     {1ex \@plus .2ex}%
                                     {\normalfont\large\bfseries\sffamily}}
\newcounter {section}
\newcounter {subsection}[section]
\setcounter{secnumdepth}{0}
\renewcommand\thesection{\@arabic\c@section}
\renewcommand\thesubsection{\thesection.\@arabic\c@subsection}
\setlength\leftmargini  {2.5em}
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\setlength\leftmarginv  {1em}
\setlength\leftmarginvi {1em}
\setlength\leftmargin    {\leftmargini}
\setlength  \labelsep  {5\p@}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\setlength\partopsep{0\p@}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\def\@listI{\setlength\leftmargin{\leftmargini}
            \setlength\parsep {.4em}%
            \setlength\topsep {.4em}%
            \setlength\itemsep{.4em}}
\let\@listi\@listI
\@listi
\def\@listii {\setlength  \leftmargin{\leftmarginii}%
              \setlength  \labelwidth{\leftmarginii}%
              \addtolength\labelwidth{-\labelsep}}
\def\@listiii{\setlength  \leftmargin{\leftmarginiii}%
              \setlength  \labelwidth{\leftmarginiii}%
              \addtolength\labelwidth{-\labelsep}%
              \setlength  \topsep    {.2em}%
              \setlength  \itemsep   {\topsep}}
\def\@listiv {\setlength  \leftmargin{\leftmarginiv}%
              \setlength  \labelwidth{\leftmarginiv}%
              \addtolength\labelwidth{-\labelsep}}
\def\@listv  {\setlength  \leftmargin{\leftmarginv}%
              \setlength  \labelwidth{\leftmarginv}%
              \addtolength\labelwidth{-\labelsep}}
\def\@listvi {\setlength  \leftmargin{\leftmarginvi}%
              \setlength  \labelwidth{\leftmarginvi}%
              \addtolength\labelwidth{-\labelsep}}
\renewcommand\theenumi{\arabic{enumi}}
\renewcommand\theenumii{\alph{enumii}}
\renewcommand\theenumiii{\roman{enumiii}}
\renewcommand\theenumiv{\Alph{enumiv}}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{$\m@th\bullet$}
\newcommand\labelitemii{\normalfont\bfseries --}
\newcommand\labelitemiiii{$\m@th\ast$}
\newcommand\labelitemiv{$\m@th\cdot$}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}

\newenvironment{verse}
               {\let\\=\@centercr
                \list{}{\setlength\itemsep{\z@}%
                        \setlength\itemindent{-15\p@}%
                        \setlength\listparindent{\itemindent}%
                        \setlength\rightmargin{\leftmargin}%
                        \addtolength\leftmargin{15\p@}}%
                \item[]}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\setlength\listparindent{1.5em}%
                        \setlength\itemindent{\listparindent}%
                        \setlength\rightmargin{\leftmargin}}%
                \item[]}
               {\endlist}
\newenvironment{quote}
               {\list{}{\setlength\rightmargin{\leftmargin}}%
                \item[]}
               {\endlist}

\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand\theequation{\arabic{equation}}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\def\LetterHeaderFont{\bfseries}
\def\LetterBodyFont{\normalfont}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\relax}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\relax}
\DeclareRobustCommand*{\cal}{\@fontswitch{\relax}{\mathcal}}
\DeclareRobustCommand*{\mit}{\@fontswitch{\relax}{\mathnormal}}
\renewcommand\footnoterule{%
  \kern-\p@
  \hrule \@width .4\columnwidth
  \kern .6\p@}
\long\def\@makefntext#1{%
    \noindent
    \hangindent 5\p@
    \hbox to5\p@{\hss\@makefnmark}#1}
\newcommand\ccname{cc}
\newcommand\enclname{encl}
\newcommand\pagename{Page}
\newcommand\headtoname{To}

\newcommand\today{\number\day\space \ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagestyle{plain}
\pagenumbering{arabic}
\raggedbottom
\def\@texttop{\ifnum\c@page=1\vskip \z@\relax\fi}
\onecolumn
\endinput
%%
%% End of file `guletter.cls'.
